# to autoload this file
proc m2Prefs.tcl {} {}



#===========================================================================
#  M2 Preferences  #
#===========================================================================


# Avoid premature early line break while typing, especially for long strings
proc setLnBreakBehavior {M2MaxLineLength} {
    global fillColumn
    global wrapLow
    global wrapHigh
    global M2modeVars
    if {[info exists M2MaxLineLength]} then {
	# make it immediately available (without requiring a mode switch)
	set fillColumn "$M2MaxLineLength"
	set wrapLow    "[expr $M2MaxLineLength -5]"
	set wrapHigh   "[expr $M2MaxLineLength +5]"
	# Still needs to set M2modeVars(wrapLow), M2modeVars(wrapHigh), and M2modeVars(fillColumn)?
	if {[info exists M2modeVars]} then {
	    set M2modeVars(m2_maxLineLength)	"$M2MaxLineLength"
	    # make final values immediately available (without requiring a mode switch)
	    set wrapLow    "[expr $M2MaxLineLength -$M2modeVars(m2_maxLnLeTol)]"
	    set wrapHigh   "[expr $M2MaxLineLength +$M2modeVars(m2_maxLnLeTol)]"
	}	
    }		
}



# The following "unconventional" assignments to M2modeVars are made to support pre 7 Alpha usage
if {[info exists M2ShellName]} then {
    set M2modeVars(m2_shellName) $M2ShellName
} else {
    # Try looking at the desktop data base, giving RAMSES higher priority than MacMETH shell
    set M2ShellName "::RMS: RAMSES Shell"
    if { [catch {nameFromAppl 'RAMS'}] } then {
	# alertnote "look for RAMS failed"
    	if { [catch {nameFromAppl 'ETHM'}] } then {
	    # alertnote "No Modula-2 shells found" 
	    set M2modeVars(m2_shellName) ""
	} else {
	    # alertnote "At least MacMETH found"
	    set M2modeVars(m2_shellName) "[file dirname [nameFromAppl 'ETHM']]: MacMETH"
	    set M2ShellName $M2modeVars(m2_shellName)
	}
    } else {
	# alertnote "RAMS found" 
	set M2modeVars(m2_shellName) "[file dirname [nameFromAppl 'RAMS']]: RAMSES Shell"
	set M2ShellName $M2modeVars(m2_shellName)
    }
}

if {[info exists M2errDOKFile]} then {
    set M2modeVars(m2_errListDOK) $M2errDOKFile
} else {
    set M2modeVars(m2_errListDOK) "[file dirname $M2modeVars(m2_shellName)]:M2Tools:ErrList.DOK"
    set M2errDOKFile $M2modeVars(m2_errListDOK)
}

if {![info exists M2ShellHome]} then {
    set M2ShellHome [file dirname $M2ShellName]
}

if {![info exists M2ErrFile]} then {
    set M2ErrFile [file join $M2ShellHome err.ALPHA]
}


if {[info exists M2Author]} then {
    set M2modeVars(m2_author) $M2Author
} else {
    if {[info exists M2modeVars(m2_author)]} then {
	set M2Author $M2modeVars(m2_author)
    } else {
	set M2Author "First Last"
    }
}

if {[info exists M2RightShift]} then {
    set M2modeVars(m2_indentAmount) $M2RightShift
} else {
    if {[info exists M2modeVars(m2_indentAmount)]} then {
	set M2RightShift $M2modeVars(m2_indentAmount)
    } else {
	set M2RightShift "  "
    }
}
# possible alternative: set M2modeVars(m2_indentAmount) $indentationAmount

if {[info exists M2LeftShift]} then {
    set M2modeVars(m2_leftShiftAmount) $M2LeftShift
} else {
    if {[info exists M2modeVars(m2_leftShiftAmount)]} then {
	set M2LeftShift $M2modeVars(m2_leftShiftAmount)
    } else {
	set M2LeftShift "  "
    }
}
if {[info exists M2WrapRightMargin]} then {
    set M2modeVars(m2_fillRightMargin) $M2WrapRightMargin
} else {
    if {[info exists M2modeVars(m2_fillRightMargin)]} then {
	set M2WrapRightMargin $M2modeVars(m2_fillRightMargin)
    } else {
	set M2WrapRightMargin "  "
    }
}

set M2modeVars(wordWrap)			        {1}
# The only M2 variable maintained only as a simple newPref var (only new mechanism)
set M2modeVars(m2_maxLnLeTol)               {5}
set M2modeVars(m2_maxLineLength)			{120}
if {[info exists M2MaxLineLength]} then {
    setLnBreakBehavior $M2MaxLineLength
} else {
    if {[info exists M2modeVars(m2_maxLineLength)]} then {
	set M2MaxLineLength $M2modeVars(m2_maxLineLength)
    } else {
	set M2MaxLineLength 120
    }
}

if {[info exists M2SaveState]} then {
    set M2modeVars(m2_savedState) $M2SaveState
} else {
    if {[info exists M2modeVars(m2_savedState)]} then {
	set M2SaveState $M2modeVars(m2_savedState)
    } else {
	set M2SaveState "mpw"
    }
}


set M2modeVars(wordBreakPreface)	{[^a-zA-Z0-9]}
set M2modeVars(wordBreak)			{[a-zA-Z0-9]+}
set M2modeVars(funcExpr)			{^[ \t]*PROCEDURE[ \t]*([^\s;(]+)}
set M2modeVars(prefixString)		{(* }
set M2modeVars(suffixString)		{ *)}
if {$curAlphaV < "7.1"} then {
    set M2modeVars(elecLBrace)			{0}
    set M2modeVars(electricSemi)		{0}
    set M2modeVars(elecRBrace)			{0}
}
# set M2modeVars(tagFile)			"$HOME:m2TAGS"

# now offer some of these prefs also for Alpha's "Config > Current Mode > Preferences..." 
	
# Elec Completions feature enabled
newPref flag elecCompletions            {1}	M2 

# Plain vanilla pasting, e.g. without extra blanks, is usually better in Modula-2
newPref flag smartCutPaste              {0}	M2 
# All indents should be made by using spaces only in Modula-2 source code
newPref flag indentUsingSpacesOnly      {1}	M2 

# Automatically mark windows on open if they don't have marks already
newPref flag autoMark	                {1}	M2 
# M-button recognizes main structural marks (created by ctrl^3)
newPref flag listMainStructuralMarks    {1} M2
# M-button recognizes subsection structural marks (created by ctrl^4, nested within main marks)
newPref flag listSectionStructuralMarks {0} M2
# M-button lists MODULES
newPref flag listModules                {1} M2
# M-button lists PROCEDURES
newPref flag listProcedures             {1} M2
# section structural marks created by ctrl^4 are large (boxed) 
newPref flag boxedSectionMarks          {1} M2
# M-button sorts listed items alphabetically (otherwise order of occurrence)
newPref flag sortListedItems            {0} M2
# procedures within comments are not marked (but mode autoscrolls and comment recognition does not always succeed)    
newPref flag markSeesComments           {0} M2
	
if {$curAlphaV < "7.1"} then {
    # Recognize { as statement block begin
    newPref flag     elecLBrace		    {0} M2
    # Recognize semicolon as statement terminator
    newPref flag     electricSemi		{0} M2
    # Recognize } as statement block end
    newPref flag     elecRBrace		    {0} M2
}
# Format of template stops (see Elec Completions for details)
newPref variable ElectricFillers    {1} M2
# Regular expression used to parse Modula-2 code while searching for procedure declarations
newPref variable parseExpr          {\b([_:\w]+)\s*\(}  M2 
# Regular expression to parse Modula-2 PROCEDUREs
newPref variable funcExpr			{^[ \t]*PROCEDURE[ \t]*([^\s;(]+)} M2 ;#-trf

# Regular expression where to break words
newPref variable wordBreak 			{[a-zA-Z0-9]+} M2
# Regular expression where to break words when searching backwards
newPref variable wordBreakPreface	{[^a-zA-Z0-9]} M2
# Text inserted at begin of every line in selection
newPref variable prefixString		{ (*} M2 adjustM2Prefs
# Text appended at end of every line in selection
newPref variable suffixString		{ *)} M2 adjustM2Prefs

# Color used for Modula-2 reserved words (keywords) such as IF, WHILE etc.
newPref variable keywordColor	    blue	M2 M2::colorizing 
# Color used for Modula-2 comments (* *)
newPref variable commentColor	    red		M2 M2::colorizing 
# Color used for strings (if delimited by quotes "")
newPref variable stringColor		magenta	M2 M2::colorizing 
# Color used for standard procedures, such as ABS, INC etc.
newPref variable standardProcColor  cyan	M2 M2::colorizing 
# Color used for objects imported from libraries
newPref variable libColor		    green	M2 M2::colorizing 

# Author (used in templates)
newPref variable m2_author	        {First Last} M2 adjustM2Prefs
# Typing a blank after a reserved word triggers a template
# e.g. IF<blank> triggers IF THEN ELSE END(*IF*);
newPref f spaceBarExpansion         {1} M2 adjustM2Prefs
# Path and name of Modula-2 shell which compiles and loads your programs
newPref variable m2_shellName	    "M2modeVars(m2_shellName)" M2 adjustM2Prefs
# File holding compiler errors for explaining erroneous source code
newPref variable m2_errListDOK	    {::RMS:M2Tools:ErrList.DOK} M2 adjustM2Prefs

# Amount of spaces inserted for indentation (TAB, right shift, CTRL-r)
newPref variable m2_indentAmount	{  } M2 adjustM2Prefs
# Amount of spaces deleted while unindenting (left shift, CTRL-l)
newPref variable m2_leftShiftAmount	{ }  M2 adjustM2Prefs
# Right fill margin for "Wrap comment" (CTRL-a) and "Wrap text" (CTRL-SHIFT-a) commands (similar to fillColumn)
newPref variable m2_fillRightMargin	{65} M2 adjustM2Prefs
# Folder which contains documentation such as quick reference files and definition modules
newPref variable docuFolder         {Docu} M2
# If true, wrap text routines (CTRL-a, CTRL-SHIFT-a) add after periods double spaces
newPref flag doubleSpaces           {1}  M2

#  Overrule Global Settings  #
# 
# incompatible settings possibly specified otherwise by Alpha's defaults and setupAssistant
# If true, lines exceeding 'm2_maxLineLength' in length are automatically wrapped during normal text insertion (typing)
newPref flag     wordWrap  		    {0} M2
# If false, don't auto continue comment (highly recommended)
newPref flag     autoContinueComment  		    {0} M2
# If false, don't back up Modula-2 source files (highly recommended)
newPref flag     backup  		    {0} M2
# If false, EMACS navigation shortcuts are not active in M2 mode
# newPref flag     emacs                      {0} M2

# Maximum length of lines beyond which automatical wrapping occurs during typing
newPref variable m2_maxLineLength	{120} M2 adjustM2Prefs
# Tolerance around m2_maxLineLength within which actual line breaks occurr
newPref variable m2_maxLnLeTol	    {5} M2 adjustM2Prefs
# Saving files with, e.g. MPW, resources
newPref variable m2_savedState		{mpw} M2 adjustM2Prefs

# Default font (could also be ProFont, or Programmer, depending on your preferences)
newPref variable defaultFont        "$defaultFont" M2
# Every M2 window has a scroll bar
newPref flag horScrollBar           {1} M2

# Target platform for which code becomes active if conditional compiler flags indicate it
newPref variable m2_TargetPlatform     {Mac} M2
# List of conditional compiler flags recognized if m2_TargetPlatform == Mac
newPref variable m2_MacCompFlagList    {DM MacMETH DM_MAC DM_MAC_OLD MW_MAC_OLD AuxLib_68KFPU} M2
# List of conditional compiler flags recognized if m2_TargetPlatform == IBM
newPref variable m2_IBMCompFlagList    {DM STONYBROOK DM_IBM AuxLib} M2
# List of conditional compiler flags recognized if m2_TargetPlatform == Sun
newPref variable m2_SunCompFlagList    {BDM EPC AuxLib} M2

# newPref file     tagFile			"$HOME:modTAGS" M2

# The following are the creators and file types which should be recognized by Alpha in order
# to fully support all RAMSES (Research Aids for Modeling and Simulation of Environmental 
# Systems) files
# set modeCreators(RAMS) RAMS
# set modeCreators(ETHM) ETHM
# set modeTypes(MoTx) MoTx   # simple text, model files, but treated differently if doubleclicked
# set modeTypes(WDBN)        # simple RTF, stash files, but treated differently if doubleclicked
# set modeTypes(XLS )        # simple text, data frame files, but treated differently if doubleclicked

# to dos:  indentationAmount, flag 'indentFollowsTabs'
# set ${mode}::startPara {^(.*\{)?[ \t]*$}
# set ${mode}::endPara {^(.*\})?[ \t]*$}


# Reporting that end of this script has been reached
message "m2Prefs.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
    alertnote "m2Prefs.tcl for Programing in Modula-2 loaded"
}
